class SpawnProtector extends UT_Invisibility ;

var name OldTag;

state Activated
{
	function endstate()
		{
		local Inventory S;
		local PlayerPawn P;
	
		P = PlayerPawn(Owner);
		P.ReducedDamageType = '';

		bActive = false;
		
		PlaySound(DeActivateSound);

		Owner.SetDefaultDisplayProperties();
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			{
			UT_Shieldbelt(S).MyEffect.bHidden = false;
			}
		}

	function Activate()
		{
		bActive = true;
		SetOwnerDisplay();
		OldTag = Owner.Tag;
		Owner.Tag = 'Protected';
		}

	function SetOwnerDisplay()
		{
		if ( !bActive )
			{
			return;
			}
		
		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield',true,true);
		}

	function ChangedWeapon()
		{
		if ( !bActive )
			{
			return;
			}
		if( Inventory != None )
			{
			Inventory.ChangedWeapon();
			}

		//Now put on some color yeah
		if ( Pawn(Owner).Weapon != None )
			{
			Pawn(Owner).Weapon.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield',true,true);
			}
		}

	function Timer()
	{
		Charge -= 1;
		Pawn(Owner).DamageScaling = 0.0;
		if (Charge<-0)
			{
			Owner.AmbientGlow = Owner.Default.AmbientGlow;
			Owner.LightType = LT_None;
			Pawn(Owner).DamageScaling = 1.0;
			UsedUp();
			Owner.Tag = OldTag;
			}
	}

	function BeginState()
	{
		local Inventory S;

		bActive = true;
		PlaySound(ActivateSound,,4.0);

		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield',false,true);
		SetTimer(0.5,True);
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			{
			UT_Shieldbelt(S).MyEffect.bHidden = true;
			}
	}

	simulated function Tick(float DT) 
	{
	local PlayerPawn P;
	
	P = PlayerPawn(Owner);

	Super.Tick(DT);

	P.ReducedDamageType = 'All';
	}
}

state DeActivated
{
Begin:
}

State Sleeping
{
    ignores Touch;

    function BeginState()
    {
        BecomePickup();
        bHidden = true;
    }
    function EndState()
    {
        local int i;

        bSleepTouch = false;
        for ( i=0; i<4; i++ )
            if ( (Touching[i] != None) && Touching[i].IsA('Pawn') )
                bSleepTouch = true;
    }           
Begin:
    Sleep( ReSpawnTime );
    PlaySound( RespawnSound );  
    Sleep( Level.Game.PlaySpawnEffect(self) );
    GoToState( 'Pickup' );
}

defaultproperties
{

     ExpireMessage="You are under spawnprotection."
     PickupMessage="Your spawnprotection has expired."
     ItemName="SpawnProtector"
     RespawnTime=0.0000
     Charge=30
     PickupSound=Sound'UnrealShare.Pickups.GenPickSnd'
     ActivateSound=Sound'BotPack.Pickups.UTSuperHeal'
     DeActivateSound=Sound'UnrealI.Generic.Teleport1'
     CollisionRadius=32.000000
     CollisionHeight=32.000000
     bCollideWhenPlacing=True
}
